$ENDPOINT="https://fructos-jami2025.jpfhir.jp:8182/fructos"
$RTYPE=Patient
$PYTHON3=python
$DATA=sampleData/Patient/Patient-Example-JP-Patient.json

#CREATE　出力を整形せず、-i オプションでレスポンスヘッダとレスポンスコードも表示
$PYTHON3 unicodeEncode.py $DATA | curl -i -H"@header.txt" -X POST -d"@-" $ENDPOINT/$RTYPE

#CREATE　Patientリソースデータ 出力を整形
$PYTHON3 unicodeEncode.py $DATA |  curl -H"@header.txt" -X POST -d"@-" $ENDPOINT/$RTYPE | $PYTHON3 -m json.tool --no-ensure-ascii | more

#CREATE　エラーのあるPatientリソースデータ 出力を整形
$DATAERR=sampleData/Patient/Patient-Example-JP-Patient_error01.json
$PYTHON3 unicodeEncode.py $DATAERR | curl -H"@header.txt" -X POST -d"@-" $ENDPOINT/$RTYPE | $PYTHON3 -m json.tool --no-ensure-ascii | more


#GET　Patientリソースデータ 出力を整形
curl -H"@header.txt"  $ENDPOINT/$RTYPE | $PYTHON3 -m json.tool --no-ensure-ascii | more

#GET　Patientリソースデータ　山本さんを検索 出力を整形
curl -H"@header.txt" --get --data-urlencode "name=山本" $ENDPOINT/$RTYPE| $PYTHON3 -m json.tool --no-ensure-ascii | more

#GET　Patientリソースデータ　山本さんを検索 出力を整形
curl -H"@header.txt" --get --data-urlencode "family=山本" --data-urlencode "giver=一郎" $ENDPOINT/$RTYPE| $PYTHON3 -m json.tool --no-ensure-ascii | more

$TARGET=sampleData/Observation-Example-Glucose.json
java -jar validator_cli.jar \
    $TARGET \
      -version 4.0.1 \
      -language ja   \
      -want-invariants-in-messages   \
      -no-extensible-binding-warnings   \
      -display-issues-are-warnings    \
      -level warnings   \
      -best-practice ignore \
      -ig pkg/jp-core.r4-1.1.2-clins.tgz  \
      -ig pkg/jpfhir-terminology.r4-1.4.0.tgz

# validateだけ実行する
$DATALABO=sampleData/Observation-Example-Glucose.json
$RTYPEOBS=Observation
$PYTHON3 unicodeEncode.py $DATALABO |  curl -H"@header.txt" -X POST -d"@-" $ENDPOINT/$RTYPEOBS/`$validate | $PYTHON3 -m json.tool --no-ensure-ascii | more

# name のないPatientリソースを JP_Patient_eCS プロファイル指定でValidationする。
$TARGET=sampleData/Patient/Patient-Example-JP-Patient-eCS_noname.json
java -jar validator_cli.jar \
    $TARGET \
      -version 4.0.1 \
      -language ja   \
      -want-invariants-in-messages   \
      -no-extensible-binding-warnings   \
      -display-issues-are-warnings    \
      -level warnings   \
      -best-practice ignore \
      -ig pkg/jp-core.r4-1.1.2-clins.tgz  \
      -ig pkg/jpfhir-terminology.r4-1.4.0.tgz \
      -ig pkg/jp-eCSCLINS.r4-1.10.0.tgz

$RTYPE=Patient
$DATA=sampleData/Patient/Patient-Example-JP-Patient-eCS_noname.json
$PYTHON3 unicodeEncode.py $DATALABO |  curl -H"@header.txt" -X POST -d"@-" $ENDPOINT/$RTYPEOBS/`$validate | $PYTHON3 -m json.tool --no-ensure-ascii | more