import sys
import os

def unicode_escape_non_ascii(text: str) -> str:
    result = []
    for ch in text:
        if ord(ch) > 127:
            result.append('\\u{:04x}'.format(ord(ch)))
        else:
            result.append(ch)
    return ''.join(result)

def main():
    if len(sys.argv) < 2:
        print("Usage: python3 unicode_escape_stdout.py <input_file>", file=sys.stderr)
        sys.exit(1)

    input_path = sys.argv[1]

    if not os.path.isfile(input_path):
        print(f"Error: file not found - {input_path}", file=sys.stderr)
        sys.exit(1)

    # UTF-8で読み込み
    with open(input_path, 'r', encoding='utf-8') as f:
        content = f.read()

    # 非ASCIIのみ \uXXXX に変換
    escaped = unicode_escape_non_ascii(content)

    # 標準出力に出力
    print(escaped, end='')

if __name__ == '__main__':
    main()
    